items.depot = New("CItem_ContentDepot")
items.depot.isDynamic = true
--items.depot.colorGround = Color(130, 130, 130, 255)
items.depot.colorItem = Color(98, 100, 120)
items.depot.uiGroup = uiGroups.transports
items.depot.models = NewCAssetModels("ItemsContent/Depot/", "Depot")
items.depot.modelsAlt = NewCAssetModels("ItemsContent/Depot/", "Arrow_depot1", "Arrow_depot2", "Arrow_depot-depot")
items.depot.modelsAlt2 = NewCAssetModels("ItemsContent/Depot/", "Depot_2nd_priority")
items.depot.forcedOrientation = 0
items.depot.stacksInfos = { NewStack(40, 120, Vector3(0, 0.08, 0)) } -- 6 bits
items.depot.dronesPosOffset = { Vector3(0.4, 0, -0.25) }
items.depot.isFloatable = true;
items.depot.waterLevelStopBuildings = 0.5


items.depotMK2 = New("CItem_ContentDepot")
items.depotMK2.isDynamic = true
items.depotMK2.colorItem = Color(98, 100, 120)
items.depotMK2.uiGroup = uiGroups.transports
items.depotMK2.models = NewCAssetModels("ItemsContent/Depot/", "Depot_mk2")
items.depotMK2.modelsAlt = NewCAssetModels("ItemsContent/Depot/", "Arrow_depot1", "Arrow_depot2", "Arrow_depot-depot")
items.depotMK2.modelsAlt2 = NewCAssetModels("ItemsContent/Depot/", "Depot_mk2_2nd_priority")
items.depotMK2.forcedOrientation = 0
items.depotMK2.upgradeOfItem = items.depot
items.depotMK2.stacksInfos = { NewStack(40, 120, Vector3(0, 0.08, 0)) } -- 6 bits
items.depotMK2.dronesPosOffset = { Vector3(0.4, 0, -0.25),
	Vector3(-0.4, 0, 0.25) }
items.depotMK2.nbDrones = 2
items.depotMK2.range = 2
items.depotMK2.isFloatable = true;
items.depotMK2.waterLevelStopBuildings = 0.5


items.depotMK3 = New("CItem_ContentDepot")
items.depotMK3.isDynamic = true
items.depotMK3.colorItem = Color(98, 100, 120)
items.depotMK3.uiGroup = uiGroups.transports
items.depotMK3.models = NewCAssetModels("ItemsContent/Depot/", "Depot_mk3")
items.depotMK3.modelsAlt = NewCAssetModels("ItemsContent/Depot/", "Arrow_depot1", "Arrow_depot2", "Arrow_depot-depot")
items.depotMK3.modelsAlt2 = NewCAssetModels("ItemsContent/Depot/", "Depot_mk3_2nd_priority")
items.depotMK3.forcedOrientation = 0
items.depotMK3.upgradeOfItem = items.depot
items.depotMK3.stacksInfos = { NewStack(40, 120, Vector3(0, 0.08, 0)) } -- 6 bits
items.depotMK3.dronesPosOffset = { Vector3(0.36, 0, -0.32),
	Vector3(-0.36, 0, 0.32),
	Vector3(0.46, 0, -0.15),
	Vector3(-0.46, 0, 0.15) }
items.depotMK3.nbDrones = 4
items.depotMK3.nbContainersPerDrone = 2
items.depotMK3.range = 3
items.depotMK3.isFloatable = true;
items.depotMK3.waterLevelStopBuildings = 0.5


items.roadway = New("CItem_Way")
items.roadway.showBuildingPreview = true
items.roadway.uiGroup = uiGroups.transports
--items.roadway.color = Color(0,0, 192)
items.roadway.colorItem = Color(118, 137, 192) -- Color(89,103,144)
items.roadway.colorWorld_itemRate = 0.8
items.roadway.models = NewCAssetModels("ItemsContent/Road/",
	"Road_Crossing1_1", "Road_Crossing1_2",
	"Road_Crossing2",
	"Road_Crossing3_1", "Road_Crossing3_2",
	"Road_Crossing4",
	"Road_Crossing5_1", "Road_Crossing5_2", "Road_Crossing5_3")
items.roadway.modelPreview = NewCAssetModel("ItemsContent/Road/Road_preview")
items.roadway.previewAltitudeNeighboorsToCheck = { 0, 3 }
items.roadway.hideGroundModels = 2
items.roadway.wayTypes = 1
items.roadway.scaleY = 1.02
items.roadway.isBuiltAsALine = true;
items.roadway.isRoundabout = true;
items.roadway.isBuildableInWater = true;



items.truck = New("CItem_Vehicle")
items.truck.uiGroup = uiGroups.transports
--items.truck.hiddenInItemBar = true
items.truck.colorItem = Color(159, 132, 131)
items.truck.models = NewCAssetModels("ItemsMisc/Truck/", "Truck2 Variant");
items.truck.wayType = 1
items.truck.wayDefault = items.roadway
items.truck.nbStacks = 1
items.truck.nbContainersPerStack = 2 -- 1
items.truck.sound = GAudio.trucks
items.truck.speedMax = 2             -- 1
items.truck.acceleration = 0.75
items.truck.accelerationBraking = 1.5
items.truck.nbContainersPerYearComputedMax = 850
items.truck.distSideWay = 0.07
items.truck.wagonLength = 0.22
items.truck.frontTargetDist = 0.15

-- maybe call it "supply point" ?
items.roadstop = New("CItem_WayStop")
items.roadstop.uiGroup = uiGroups.transports
items.roadstop.hiddenInItemBar = true
items.roadstop.colorItem = Color(118, 137, 192)
items.roadstop.showBuildingPreview = false
items.roadstop.colorWorld_itemRate = 0.9
items.roadstop.models = NewCAssetModels("ItemsContent/RoadStop/", "RoadStop1", "RoadStop1", "RoadStop2", "RoadStop2",
	"RoadStop2", "RoadStop2");
items.roadstop.modelsAlt = NewCAssetModels("ItemsContent/RoadStop/", "RoadStop1_loading3", "RoadStop1_loading3",
	"RoadStop2_loading3", "RoadStop2_loading3", "RoadStop2_loading3", "RoadStop2_loading3");
items.roadstop.modelsAlt2 = NewCAssetModels("ItemsContent/RoadStop/", "RoadStop1_unloading3", "RoadStop1_unloading3",
	"RoadStop2_unloading3", "RoadStop2_unloading3", "RoadStop2_unloading3", "RoadStop2_unloading3");
items.roadstop.isDynamic = true
items.roadstop.hideGroundModels = 2
items.roadstop.wayTypes = 1
items.roadstop.isRoundabout = true
items.roadstop.itemVehicle = items.truck
items.roadstop.preventDrag = true;

items.railway = New("CItem_Way")
items.railway.uiGroup = uiGroups.transports
items.railway.colorItem = Color(120, 120, 120) --Color(174, 166, 145)
items.railway.colorWorld_itemRate = 0.8
items.railway.models = NewCAssetModels("ItemsContent/Rail/", "Rail_Straight", "Rail_Curve_2", "Rail_EndRail")
items.railway.modelsAlt = NewCAssetModels("ItemsContent/Rail/", "Rail_EndExtracted")
items.railway.wayTypes = 2
--items.railway.scaleY = 1
items.railway.isBuiltAsALine = true;
items.railway.isBuildableInWater = true;

items.train = New("CItem_Vehicle")
items.train.uiGroup = uiGroups.transports
--items.train.hiddenInItemBar = true
items.train.colorItem = Color(200, 200, 200)
items.train.models = NewCAssetModels("ItemsMisc/Train/", "Train_Wagon2");
items.train.modelsAlt = NewCAssetModels("ItemsMisc/Train/", "Train_Locomotive2");
items.train.wayType = 2
items.train.wayDefault = items.railway
items.train.nbStacks = 15
items.train.nbContainersPerStack = 2
items.train.sound = GAudio.trains
items.train.canUTurn = false;
items.train.speedMax = 3            --2
items.train.acceleration = 0.16     -- 15 -- 0.3
items.train.accelerationBraking = 2 -- 1
items.train.nbContainersPerYearComputedMax = 2000
items.train.distSideWay = 0.118
items.train.altitudeAboveWay = 0.05
items.train.wagonLength = 0.31
items.train.frontTargetDist = 0.39
items.train.containerOffset = Vector3(0, 0.066, 0.155);

items.railstop = New("CItem_WayStop")
items.railstop.uiGroup = uiGroups.transports
items.railstop.hiddenInItemBar = true
items.railstop.colorItem = Color(145, 141, 179)
items.railstop.colorWorld_itemRate = 0.9
items.railstop.UVsSpecial = 12
items.railstop.models = NewCAssetModels("ItemsContent/Rail/", "Rail_Straight", "Rail_Curve_2", "Rail_EndRail")
items.railstop.modelsSignal = NewCAssetModels("ItemsContent/RailStop/", "RailStop2")
items.railstop.modelsAlt = NewCAssetModels("ItemsContent/Rail/", "Rail_EndExtracted")
items.railstop.isDynamic = true
items.railstop.wayTypes = 2
items.railstop.itemVehicle = items.train
items.railstop.preventDrag = true;

items.cross = New("CItem_WayCross")
items.cross.colorItem = Color(224, 214, 188)
items.cross.colorWorld_itemRate = 0.8
items.cross.wayTypes = 1 + 2
items.cross.isBuildableInWater = true;
items.cross.showBuildingPreview = true;
items.cross.modelPreview = NewCAssetModel("ItemsContent/Road/Road_preview")

items.crossRoadBuoy = New("CItem_WayCross")
items.crossRoadBuoy.colorItem = Color(224, 214, 188)
items.crossRoadBuoy.colorWorld_itemRate = 0.8
items.crossRoadBuoy.wayTypes = 1 + 4
items.crossRoadBuoy.isBuildableInWater = true;
items.crossRoadBuoy.showBuildingPreview = true;
items.crossRoadBuoy.modelPreview = NewCAssetModel("ItemsContent/Road/Road_preview")

items.crossRailBuoy = New("CItem_WayCross")
items.crossRailBuoy.colorItem = Color(224, 214, 188)
items.crossRailBuoy.colorWorld_itemRate = 0.8
items.crossRailBuoy.wayTypes = 2 + 4
items.crossRailBuoy.isBuildableInWater = true;
items.crossRailBuoy.showBuildingPreview = true;
items.crossRailBuoy.modelPreview = NewCAssetModel("ItemsContent/Rail/Rail_Straight")

-- items.crossRoadRailBuoy = New("CItem_WayCross")
-- items.crossRoadRailBuoy.colorItem = Color(224, 214, 188)
-- items.crossRoadRailBuoy.colorWorld_itemRate = 0.8
-- items.crossRoadRailBuoy.wayTypes = 1 + 2 + 4
-- items.crossRoadRailBuoy.isBuildableInWater = true;
-- items.crossRoadRailBuoy.showBuildingPreview = true;

items.buoy = New("CItem_WayShip")
items.buoy.uiGroup = uiGroups.debug
items.buoy.models = NewCAssetModels("ItemsContent/BuoyStop/", "Buoy1")
items.buoy.colorItem = Color(200, 200, 200)
items.buoy.colorWorld_itemRate = 0.4
items.buoy.forcedOrientation = 90
items.buoy.isFloatable = true
items.buoy.wayTypes = 4
items.buoy.preventDrag = true;
items.buoy.isMultiSelectable = false

items.containerShip = New("CItem_Vehicle")
items.containerShip.uiGroup = uiGroups.transports
items.containerShip.colorItem = Color(200, 200, 200)
items.containerShip.models = NewCAssetModels("ItemsMisc/ContainerShip/", "ContainerShip Variant");
items.containerShip.wayType = 4
items.containerShip.wayDefault = nil
items.containerShip.nbStacks = 6 * 7
items.containerShip.nbContainersPerStack = 8
-- items.containerShip.sound = GAudio.containerShips
items.containerShip.speedMax = 1.5 -- 0.8
items.containerShip.speedLow = 0.05
items.containerShip.acceleration = 0.1
items.containerShip.accelerationBraking = 1
items.containerShip.nbContainersPerYearComputedMax = 7500
-- items.containerShip.distSideWay = 0.7
items.containerShip.wagonLength = 1.5
items.containerShip.frontTargetDist = 1.5
items.containerShip.isFloatable = true
items.containerShip.rideOnNeighbors = true
items.containerShip.wayShip = items.buoy
items.containerShip.isVisibleIntermediary = true
items.containerShip.containerShipStack = true
items.containerShip.sinkStacksFull = -0.08
items.containerShip.sinkStacksEmpty = 0.1
items.containerShip.distStopRegistration = 1
items.containerShip.sound = GAudio.ship
items.containerShip.soundDeparture = GAudio.shipHorn
items.containerShip.rerouteCooldown = 4


items.buoyStop = New("CItem_WayStop")
items.buoyStop.uiGroup = uiGroups.transports
items.buoyStop.hiddenInItemBar = true
items.buoyStop.models = NewCAssetModels("ItemsContent/BuoyStop/", "BuoyStop1", "BuoyStop2")
items.buoyStop.colorItem = Color(200, 200, 200)
items.buoyStop.colorWorld_itemRate = 0.4
items.buoyStop.forcedOrientation = 90
items.buoyStop.isBuildableInWater = true
items.buoyStop.itemVehicle = items.containerShip
items.buoyStop.isFloatable = true
items.buoyStop.hasWayPath = false
items.buoyStop.wayTypes = 4
items.buoyStop.isDynamic = true
items.buoyStop.preventDrag = true;
